// In this example the coroutine reads row-by-row text from a file. When a row is read, the coroutine 
// sends it to caller. The caller prints it, then the reader continues.
// Return type class is not needed.
#include <coroutine>
#include <generator> // C++ v. 23
generator<string> coro_reader(fstream& f)
{
	cout << "started" << endl;
	char line[256];
	while (true)
	{
		f.getline(line, 256);
		if (f.eof())
		{
			cout << "No more data" << endl;
			break;
		}
		co_yield(string(line));
	}
	cout << "coro_7 ended" << endl; // no return expression here, the control is switched back to caller
}

void Test()
{
	fstream File;
	File.open("C:\\Temp\sometext.txt", fstream::in);
	if (!File.good())
	{
		cout << "Failed to open file" << endl;
		return;
	}
	for (string s : coro_reader(File))
	{
		cout << "got " << s << endl;
	}
	File.close();
}